/**********************************************************************
 * tiny13_lights                                                      *
 *  ATtiny13   4-  . *
 *      Effects.c                  *
 **********************************************************************/
 
//#define F_CPU 1200000UL
#include <tiny13.h>
#include <delay.h>
#define uint8_t unsigned char
#define uint16_t unsigned int

//
#define EL0     PORTB0       //  0
#define EL1     PORTB2       //  1
//#define EL2     PORTB0       //  2
//#define EL3     PORTB2       //  3
#define BUTTON  PORTB5       // 
#define ZC      PORTB1       //   (INT0)

#define BUTTON_PRESSED    (!(PINB & (1 << BUTTON)))    //  

uint8_t  mode;               //  
uint8_t  maxmode;            //   
uint8_t  currentStage;       //   
uint8_t  maxStage;           //   
uint16_t timer;              //    
uint16_t currentPeriod;      //    
uint16_t maxPeriod;          //        
uint8_t  currentAngle;       //    ( 0  maxAngle)
#define  minAngle      Angles[3]     //        
#define  risingAngle   Angles[2]     //     
#define  fallingAngle  Angles[1]     //     
#define  maxAngle      Angles[0]     //        
uint8_t  angle[2];                   //    1-4 
#define  Flags         ADMUX                // ,      
//#define  Flag2         ADCSRB        //ADCSRA       //DWDR
//#define  INVERT i&0x80
#define  DIR1   i&0x40
#define  DIR0   i&0x20
#define  _I     0b10000000
#define  _F     0b01100000
#define  _B     0b01000000
#define  _S     0b00100000
#define  _R     0b00000000

#define  AUTOB  Flags.6              // 
#define  DIR    Flags.5              //   
#define  SINHRO Flags.1              // 
#define  INVERT Flags.0 
uint8_t  Effect;

//#define halfAngle minAngle+STEPS/2
#include <Effects.c>
uint8_t  Angles[4]={0,0,0,Otstup1};
#if PWM_ENABLED==2
#define  DEFPORT       ~((0<<ZC)|(1<<EL0)|(1<<EL1))
#else
#define  DEFPORT       ~((1<<ZC)|(1<<EL0)|(1<<EL1))
#endif

void main(void)
{// Reset Source checking  
uint8_t i;  
uint8_t tmp;  
if (MCUSR & (1<<EXTRF))
    {
    // External Reset
    maxmode=(sizeof(MAPM))&0xFE;
    mode++;
    if(AUTOB) mode=maxmode;
    AUTOB=0;
    }  
if ((MCUSR & ((1<<PORF)|(1<<BORF)))||(timer<=(70)))    
    {
    // Power-on Reset  // Brown-Out Reset // DoubleClick
    maxmode=(sizeof(MAPA))&0xFE;
    AUTOB=1;
    mode=maxmode;
    }
    //SINHRO=0;
    MCUSR=0;    
    

    // Crystal Oscillator division factor: 4
#pragma optsize-
    CLKPR=(1<<CLKPCE);
    CLKPR=(0<<CLKPCE) | (2<<CLKPS0);
#ifdef _OPTIMIZE_SIZE_
#pragma optsize+
#endif

    //   /:
    DDRB  = (1<<EL0)|(1<<EL1);
    PORTB = DEFPORT; //    PB5

    //   :
#if (PWM_ENABLED==2)
    GIMSK=(0<<INT0) | (0<<PCIE);        //    .
#else
    //GIFR = (1<<INTF0) | (0<<PCIF);
    GIMSK= (1<<INT0)  | (0<<PCIE);        //    INT0.
#endif
    MCUCR = 0b00100001;        //    INT0    (   )

    //   T0   10 (F=1200000/120=10000, =1/10000=100):
    TCCR0A    = 0b00000010;    //  CTC (    OCR0A)
    TCCR0B    = 0b00000010;    //    
    OCR0A     = (3000/(STEPS+Otstup2+Otstup1))-1; //119;           //    A     ...
    TIMSK0    = 0b00000100;    //       OCR0A
        
    #asm("sei") //  

    //  
    while(1)
    {
    #if SLEEP 
    #asm("sleep")
    #else
    while(SINHRO){};
    SINHRO=1;
    #endif
    

if (mode&0x01)
    { //  
    tmp =  EFF[Effect+(currentStage>>1)]; 
    if (INVERT) tmp=~tmp;   
    if ((currentStage&1)==0) tmp>>=4;
    angle[0] = Angles[tmp&3];
    tmp>>=2;
    angle[1] = Angles[tmp&3];

    timer++; 
    if ((AUTOB)&(timer>(AUTOBUTTON*100))) mode++;   // 
    }
else
    { // 
    mode++;
    currentPeriod = 0;    //..   
    currentStage = 2;
    if (mode>maxmode) mode=1;
    if (AUTOB)
        {
        i = MAPA[mode];
        Effect = MAPA[mode-1];
        }
    else
        {
        i = MAPM[mode];
        Effect = MAPM[mode-1];
        };          
    maxStage  = EFF[Effect];;
    
    INVERT=0;
    if (i&0x80) INVERT=1;
    if (DIR1)
        {
        if (DIR0) DIR=0;                             //  
        }
    else
        {
        if (DIR0) {if(DIR) DIR=0; else DIR=1;}       // 
        #if (PWM_ENABLED==2)
        else      {if(timer&1) DIR=1; else DIR=0;};  //  
        #else
        else      {if(TCNT0&1) DIR=1; else DIR=0;};  //  
        #endif
        };   
    timer=0;

    i&=0x1F;   //     
    #pragma warn-
    maxPeriod=((char)i&3)+4; 
    #pragma warn+
    i>>=2;
    maxPeriod<<=i; 
    };
}
}

//  
#if (PWM_ENABLED==2)
void in_sinhro (void){
#else
interrupt [EXT_INT0] void ext_int0_isr(void){
#endif
// #asm("wdr")
#if PWM_ENABLED 
PORTB = DEFPORT; //    
#endif
maxAngle = currentAngle - Otstup2; //         
currentAngle = 0; //   
#if (PWM_ENABLED<2)
GIMSK=(0<<INT0) | (0<<PCIE);
#endif
SINHRO=0;
}

// 
interrupt [TIM0_COMPA] void timer0_compa_isr(void){
#if !PWM_ENABLED
    PORTB = DEFPORT; //     
#endif

if ( currentAngle == angle[0]) { if (DIR) PORTB |= (1 << EL0); else PORTB |= (1<<EL1); }; //   (  ...
if ( currentAngle == angle[1]) { if (DIR) PORTB |= (1 << EL1); else PORTB |= (1<<EL0); }; //   (  ...

if (~currentAngle) currentAngle++; else GIMSK = (1<<INT0) | (0<<PCIE); //   

//    :
if ( currentPeriod < maxPeriod )     //  
    currentPeriod++;
else
    {currentPeriod = 0; //   

    if ( risingAngle < maxAngle )
        {
        risingAngle++; //   
        }
        else
        {
        risingAngle = minAngle; //   

        if ( currentStage <= maxStage ) currentStage++; //     
            else                       currentStage=2; //     (  )
		}
	fallingAngle = maxAngle - risingAngle + minAngle;  //   
	}

#if (PWM_ENABLED==2)
if (currentAngle==(STEPS+Otstup2+Otstup1))  in_sinhro();
#else
if (currentAngle==(STEPS+Otstup2+Otstup1-FILTER))
    {
    GIFR = (1<<INTF0) | (0<<PCIF);
    GIMSK = (1<<INT0) | (0<<PCIE);    //    INT0,
    }
#endif
}
